ServerEvents.recipes((event) => {
  let materials_replacements = [
    //Raw Ores
    ["modern_industrialization:raw_silver", "occultism:raw_silver"],
    ["modern_industrialization:raw_silver_block", "occultism:raw_silver_block"],
    ["modern_industrialization:raw_uranium", "mekanism:raw_uranium"],
    [
      "modern_industrialization:raw_uranium_block",
      "mekanism:block_raw_uranium",
    ],
    ["modern_industrialization:raw_lead", "mekanism:raw_lead"],
    ["modern_industrialization:raw_lead_block", "mekanism:block_raw_lead"],
    ["modern_industrialization:raw_tin", "mekanism:raw_tin"],
    ["modern_industrialization:raw_tin_block", "mekanism:block_raw_tin"],
    ["modern_industrialization:raw_platinum", "ftbmaterials:platinum_raw_ore"],


    //Blocks
    ["modern_industrialization:steel_block", "mekanism:block_steel"],
    ["modern_industrialization:bronze_block", "mekanism:block_bronze"],
    ["modern_industrialization:tin_block", "mekanism:block_tin"],
    ["modern_industrialization:lead_block", "mekanism:block_lead"],
    ["modern_industrialization:uranium_block", "mekanism:block_uranium"],
    ["modern_industrialization:silver_block", "occultism:silver_block"],

    //Ingots
    ["modern_industrialization:steel_ingot", "mekanism:ingot_steel"],
    ["modern_industrialization:bronze_ingot", "mekanism:ingot_bronze"],
    ["modern_industrialization:tin_ingot", "mekanism:ingot_tin"],
    ["modern_industrialization:lead_ingot", "mekanism:ingot_lead"],
    ["modern_industrialization:uranium_ingot", "mekanism:ingot_uranium"],
    ["modern_industrialization:silver_ingot", "occultism:silver_ingot"],

    //Nuggets
    ["modern_industrialization:steel_nugget", "mekanism:nugget_steel"],
    ["modern_industrialization:bronze_nugget", "mekanism:nugget_bronze"],
    ["modern_industrialization:tin_nugget", "mekanism:nugget_tin"],
    ["modern_industrialization:lead_nugget", "mekanism:nugget_lead"],
    ["modern_industrialization:uranium_nugget", "mekanism:nugget_uranium"],
    ["modern_industrialization:silver_nugget", "occultism:silver_nugget"],

    //Dusts
    ["modern_industrialization:lapis_dust", "mekanism:dust_lapis_lazuli"],
    ["modern_industrialization:steel_dust", "mekanism:dust_steel"],
    ["modern_industrialization:bronze_dust", "mekanism:dust_bronze"],
    ["modern_industrialization:tin_dust", "mekanism:dust_tin"],
    ["modern_industrialization:lead_dust", "mekanism:dust_lead"],
    ["modern_industrialization:uranium_dust", "mekanism:dust_uranium"],
    ["modern_industrialization:sulfur_dust", "mekanism:dust_sulfur"],
    ["modern_industrialization:coal_dust", "mekanism:dust_coal"],
    ["modern_industrialization:wood_pulp", "mekanism:sawdust"],
    ["modern_industrialization:quartz_dust", "mekanism:dust_quartz"],
    ["modern_industrialization:emerald_dust", "mekanism:dust_emerald"],
    ["modern_industrialization:diamond_dust", "mekanism:dust_diamond"],
    ["modern_industrialization:iron_dust", "mekanism:dust_iron"],
    ["modern_industrialization:gold_dust", "mekanism:dust_gold"],
    ["modern_industrialization:copper_dust", "mekanism:dust_copper"],
    ["modern_industrialization:silver_dust", "occultism:silver_dust"],
    ["extended_industrialization:netherite_dust", "mekanism:dust_netherite"],
  ];

  materials_replacements.forEach((recipe) => {
    //MI
    event.replaceInput(
      { mod: "modern_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
    event.replaceOutput(
      { mod: "modern_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );

    //Extended MI
    event.replaceInput(
      { mod: "extended_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
    event.replaceOutput(
      { mod: "extended_industrialization" },
      `${recipe[0]}`,
      `${recipe[1]}`
    );
  });



  // Heavy Water 10000
  event
    .custom({
      type: "modern_industrialization:centrifuge",
      eu: 2,
      duration: 100,
      fluid_inputs: [
        {
          amount: 10000,
          fluid: "mekanism:heavy_water",
        },
      ],
      fluid_outputs: [
        {
          amount: 10000,
          fluid: "modern_industrialization:heavy_water",
        },
      ],
    })
    .id("ftbevolution:heavy_water_convertion");

  event
    .custom({
      type: "modern_industrialization:mixer",
      eu: 32,
      duration: 80,
      fluid_inputs: [
        {
          fluid: "modern_industrialization:crude_oil",
          amount: 100,
        },
      ],
      item_inputs: [
        {
          item: "actuallyadditions:crystallized_canola_seed",
          amount: 1,
        },
      ],
      fluid_outputs: [
        {
          fluid: "actuallyadditions:crystallized_oil",
          amount: 600,
        },
      ],
    })
    .id("ftbevolution:crystallized_oil");


    event
    .custom({
      type: "extended_industrialization:alloy_smelter",
      eu: 4,
      duration: 200,
      item_inputs: [
        {
          tag: "c:dusts/tin",
          amount: 1,
        },        {
          tag: "c:dusts/copper",
          amount: 3,
        }
      ],
      item_outputs: [
        {
          item: "ftbmaterials:bronze_ingot",
          amount: 4,
        },
      ],
    })
    .id("ftbevolution:bronze_ingot_from_dusts");

    
    event
    .custom({
      type: "extended_industrialization:alloy_smelter",
      eu: 4,
      duration: 200,
      item_inputs: [
        {
          tag: "c:ingots/tin",
          amount: 1,
        },        {
          tag: "c:ingots/copper",
          amount: 3,
        }
      ],
      item_outputs: [
        {
          item: "ftbmaterials:bronze_ingot",
          amount: 4,
        },
      ],
    })
    .id("ftbevolution:bronze_ingot_from_ingots");

    event
    .custom({
      type: "modern_industrialization:mixer",
      eu: 32,
      duration: 40,
      fluid_inputs: [
        {
          fluid: "actuallyadditions:crystallized_oil",
          amount: 100,
        },
      ],
      item_inputs: [
        {
          item: "actuallyadditions:empowered_canola_seed",
          amount: 1,
        },
      ],
      fluid_outputs: [
        {
          fluid: "actuallyadditions:empowered_oil",
          amount: 600,
        },
      ],
    })
    .id("ftbevolution:empowered_oil");

event.custom({
  "type": "modern_industrialization:assembler",
  "duration": 400,
  "eu": 64,
  "fluid_inputs": [
    {
      "amount": 90,
      "fluid": "mffs:fortron_fluid"
    }
  ],  
  "item_inputs": [
    {
      "amount": 4,
      "item": "geneticsresequenced:dna_helix"
    },
    {
      "amount": 4,
      "item": "modern_industrialization:qubit"
    },
    {
      "amount": 16,
      "item": "mekanism:ultimate_control_circuit"
    },
    {
      "amount": 16,
      "item": "megacells:accumulation_processor"
    }
  ],
  "item_outputs": [
    {
      "amount": 1,
      "item": "ftbevolution:bio_neural_circuit"
    }
  ]
}).id("ftb:bio_neural_circuit");

});
